% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 24April2012
% Function: Calculates effective fee rate to be applied on the whole asset
% volume
% Related web page:
% http://finaquant.com/fee-calculator-and-analyzer-for-share-classes-of-mutual-funds-1-calculation/991
function [EffectiveFeeRate,VolumeRange] = calculate_fee_scale(AssetVolume, FeeScale, ScaleCalcLogic)
% check size of FeeRates
[rows, cols] = size(FeeScale);
if cols ~= 2
  error 'Matrix FeeRates must have 2 columns!';
end

VolumeRange = 1;
while VolumeRange < rows && AssetVolume > FeeScale(VolumeRange, 2)
    VolumeRange = VolumeRange + 1;
end

if VolumeRange > rows
    error 'AssetVolume cannot be the larger than the highest volume limit in fee scale!';
end

switch ScaleCalcLogic
    case {'class'}
        EffectiveFeeRate = FeeScale(VolumeRange,1);
        
    case {'level'}
        TotalFee = 0;
        PreviousRangeLimit = 0;
        
        for i=1:VolumeRange
            if i < VolumeRange
                RangeVolume = FeeScale(i,2) - PreviousRangeLimit;
            else    % i = VolumeRange
                RangeVolume = AssetVolume - PreviousRangeLimit;
            end
            TotalFee = TotalFee + FeeScale(i,1) * RangeVolume;
            PreviousRangeLimit = FeeScale(i,2);
        end
        EffectiveFeeRate = TotalFee / AssetVolume;
    otherwise
        error 'Undefined fee scale calculation logic!';
end

                
                
            
            



